#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// San PGATR shaderMod01.fsh  by  jviedma   
//https://www.shadertoy.com/view/lsGGRc
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Javier Viedma - jviedma/2016
// MASTER UNIVERSITARIO EN INFORMÃTICA GRAFICA, VIDEOJUEGOS Y REALIDAD VIRTUAL. PGATR. PRÃCTICA 1.
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Just Training with IÃ±igo Quilez tutorials
// References: https://www.youtube.com/watch?v=0ifChJ0nJfM

vec4 pintaCorazon(vec2 uv, vec2 despl,vec4 color1 ,vec4 color2, vec4 color3, vec4 bgColor, float tamano, float brightradius,vec2 brightcenter, float maximo, float minimo)
{
    //Corazon: no es un corazon de nadie, es propio: j.viedma
    

    vec2 q = uv + despl;
    vec2 center = vec2(0.0,0.0)- despl;
    
    float tamanobase = mix(minimo,maximo,tamano);
    
    float arturadelpedaso = mix(0.4,0.6,sin(tamano*3.14*2.));
    float anchuradelpedaso = mix(1.4,1.7,sin(tamano*3.14*1.));
    float aperturadelpedaso = mix(1.7,2.0,sin(tamano*3.14*2.));
    float larguradelpedaso = mix(0.3,0.25,sin(tamano*3.14*1.));
    
    float radius = (tamanobase + 0.25*cos(sin(q.y*anchuradelpedaso)/cos(q.x)*aperturadelpedaso -6.*abs(sin(q.x))) + larguradelpedaso *(sin(3.14*q.y+arturadelpedaso))); //esta es la funciÃ³n que define el corazon
    
    float brightdiffuse = 0.1 + clamp(0.11,0.15,tamano); //modifica esto para hacer el brillo mas difuso o menos
    
    vec4 HeartColor = mix(color2,color3,(length(q+brightcenter)));
    HeartColor = mix(color1,HeartColor,smoothstep(brightradius-brightdiffuse,brightradius+brightdiffuse,sqrt(length(q+brightcenter))));
	
    
    float val = smoothstep(radius+0.01,radius-0.01,length(uv-center)); //aqui se pinta el corazÃ³n y sus colores
    return mix(bgColor,HeartColor,val);
}

vec4 pintaFondo(vec2 uv, vec4 color1 ,vec4 color2,vec2 posluz)
{
    return  mix(color1,color2,smoothstep(0.0,2.0,sqrt(length(uv-posluz))));
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x = uv.x * iResolution.x/iResolution.y;
    
    //Colorines
    vec4 pink = vec4(1.0,.6,0.6,1.0);
    vec4 purple = vec4(.6,.0,0.5,1.0);
    vec4 darkpurple = vec4(.3,.0,0.2,1.0);
    vec4 red = vec4(1.0,0.0,0.0,1.0);
    vec4 red2 = vec4(0.4,0.1,0.01,1.0);
    vec4 white = vec4(1.0,1.0,1.0,1.0);
    vec4 bg = vec4(0.2,0.2,0.2,0.2);
    
    //Color de fondo
    vec4 ret = pintaFondo(uv, pink ,darkpurple, vec2(sin(iTime)*atan(iTime)*0.2+0.7,cos(iTime)*0.2+0.7));
    //ret = mix(ret , pintaFondo(uv,bg,purple, vec2(-0.7,-0.7)),smoothstep(0.4,1.0,sqrt(length(vec2(0.7,0.7)-vec2(-0.7,-0.7)))));
    
    
    
    //Corazoncitos
    float velocidadlatido = 3.; //Con esto se controla la velocidad del latido
    float velocidadlatido2 = 5.;
    
    float time = smoothstep(0.5,1.,1.5*sin(iTime*velocidadlatido));
    float minitime = smoothstep(0.5,1.,1.5*sin(iTime*velocidadlatido2));
    
    
    ret = pintaCorazon(uv, vec2(cos(iTime+3.14),sin(iTime+3.14)),white,pink,purple,ret,clamp(0.1,0.4,minitime),0.3,vec2(-0.2,-0.3),0.1,0.4);
    
    ret = pintaCorazon(uv, vec2(0.0,0.2),white,red,red2,ret,time,0.3,vec2(-0.3,-0.4),0.5,0.65);
    
    ret = pintaCorazon(uv, vec2(1.2*cos(iTime),1.1*sin(iTime)),white,pink,purple,ret,clamp(0.1,0.4,minitime),0.3,vec2(-0.2,-0.3),0.1,0.4);

    
	fragColor = ret;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

